/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity.fluid;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncFluid;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.material.Fluid;

public abstract class FluidContainer {
    public static final long BUCKET_CAPACITY = Services.FLUID.getBucketCapacity();
    public static final long BOTTLE_CAPACITY = Services.FLUID.getBottleCapacity();

    protected FluidContainer() {
    }

    public abstract long getCapacity();

    public abstract boolean isEmpty();

    public abstract Fluid getStoredFluid();

    public abstract long getStoredAmount();

    protected abstract void setStored(Fluid var1, long var2);

    public abstract long push(Fluid var1, long var2, boolean var4);

    public abstract Pair<Fluid, Long> pull(long var1, boolean var3);

    public abstract void load(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void save(CompoundTag var1, HolderLookup.Provider var2);

    public final void sync(BlockEntity owner) {
        ChunkSource chunkSource;
        Level level = owner.getLevel();
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = owner.getBlockPos();
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageSyncFluid(pos, this.getStoredFluid(), this.getStoredAmount())));
        }
    }

    public final void handleSync(Level level, Fluid fluid, long amount) {
        Preconditions.checkState((boolean)level.isClientSide());
        this.setStored(fluid, amount);
    }

    public static FluidContainer create(long capacity) {
        return Services.FLUID.createFluidContainer(capacity, null);
    }

    public static FluidContainer create(long capacity, Consumer<FluidContainer> onChange) {
        return Services.FLUID.createFluidContainer(capacity, onChange);
    }
}

