/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import twilightforest.block.JarBlock;
import twilightforest.block.entity.JarBlockEntity;
import twilightforest.components.item.JarLid;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFParticleType;

public class FireflyJarBlock
extends JarBlock {
    public FireflyJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof JarBlockEntity) {
            JarBlockEntity jarBE = (JarBlockEntity)blockEntity;
            ItemEntity firefly = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack(TFBlocks.FIREFLY));
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            firefly.spawnAtLocation(firefly.getItem());
            firefly.spawnAtLocation((ItemStack)Util.make((Object)new ItemStack((ItemLike)TFBlocks.MASON_JAR.get()), jar -> jar.set((DataComponentType)TFDataComponents.JAR_LID.get(), (Object)new JarLid(jarBE.lid))));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 2; ++i) {
            double dx = (float)pos.getX() + ((random.nextFloat() - random.nextFloat()) * 0.2f + 0.5f);
            double dy = (float)pos.getY() + 0.4f + (random.nextFloat() - random.nextFloat()) * 0.3f;
            double dz = (float)pos.getZ() + ((random.nextFloat() - random.nextFloat()) * 0.2f + 0.5f);
            level.addParticle((ParticleOptions)TFParticleType.FIREFLY.get(), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }
}

