/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class FixedHumanoidModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private final float armWidth;

    public FixedHumanoidModel(ModelPart part, float armWidth) {
        super(part);
        this.armWidth = armWidth;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        boolean flag2;
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.yRot = 0.0f;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = entity.getMainArm() == HumanoidArm.RIGHT;
        if (entity.isUsingItem()) {
            boolean flag3;
            boolean bl2 = flag3 = entity.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm((LivingEntity)entity);
            } else {
                this.poseLeftArm((LivingEntity)entity);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm((LivingEntity)entity);
                this.poseRightArm((LivingEntity)entity);
            } else {
                this.poseRightArm((LivingEntity)entity);
                this.poseLeftArm((LivingEntity)entity);
            }
        }
        this.setupAttackAnimation(entity, ageInTicks);
        if (this.rightArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = limbSwing % 26.0f;
            HumanoidArm humanoidarm = this.getAttackArm((LivingEntity)entity);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!entity.isUsingItem()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f * f6));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f3 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f3);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f3));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            this.leftLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f))));
        }
        this.hat.copyFrom(this.head);
    }

    protected void setupAttackAnimation(T pLivingEntity, float pAgeInTicks) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm((LivingEntity)pLivingEntity);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.rightArm.z = Mth.sin((float)this.body.yRot) * (this.armWidth + 1.0f);
            this.rightArm.x = -Mth.cos((float)this.body.yRot) * (this.armWidth + 1.0f);
            this.leftArm.z = -Mth.sin((float)this.body.yRot) * (this.armWidth + 1.0f);
            this.leftArm.x = Mth.cos((float)this.body.yRot) * (this.armWidth + 1.0f);
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    private float quadraticArmUpdate(float pLimbSwing) {
        return -65.0f * pLimbSwing + pLimbSwing * pLimbSwing;
    }
}

