/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.boss.HydraNeck;

public class HydraNeckModel
extends ListModel<HydraNeck> {
    private final ModelPart neck;

    public HydraNeckModel(ModelPart root) {
        this.neck = root.getChild("neck");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? HydraNeckModel.createJappaModel() : HydraNeckModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -23.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.neck);
    }

    public void setupAnim(HydraNeck entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.neck.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

