/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.passive.Squirrel;

public class SquirrelModel
extends QuadrupedModel<Squirrel> {
    private final ModelPart tail;
    private final ModelPart tailPart1;
    private final ModelPart tailPart2;

    public SquirrelModel(ModelPart root) {
        super(root, false, 4.0f, 4.0f, 2.0f, 2.0f, 24);
        this.tail = this.body.getChild("tail");
        this.tailPart1 = this.tail.getChild("tail_1");
        this.tailPart2 = this.tailPart1.getChild("tail_2");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? SquirrelModel.createJappaModel() : SquirrelModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = QuadrupedModel.createBodyMesh((int)0, (CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -5.0f, -3.0f, 4.0f, 4.0f, 4.0f).texOffs(16, 0).addBox(-2.0f, -6.0f, -0.5f, 1.0f, 1.0f, 1.0f).texOffs(16, 0).addBox(1.0f, -6.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().mirror().texOffs(0, 8).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-2.0f, (float)23.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.0f, (float)23.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-2.0f, (float)23.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.0f, (float)23.0f, (float)-2.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 18).addBox(-0.5f, -1.5f, 0.5f, 1.0f, 1.0f, 1.0f).texOffs(0, 20).addBox(-1.5f, -4.0f, 1.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tail1 = tail.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)-4.0f, (float)2.5f));
        tail1.addOrReplaceChild("tail_2", CubeListBuilder.create().texOffs(0, 26).addBox(1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = QuadrupedModel.createBodyMesh((int)1, (CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f).addBox(-2.0f, -3.0f, -1.0f, 1.0f, 1.0f, 1.0f).texOffs(0, 2).addBox(1.0f, -3.0f, -1.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-3.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -3.0f, -3.0f, 4.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)23.0f, (float)-2.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(4, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.5f, (float)23.0f, (float)-2.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 18).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)23.0f, (float)1.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(4, 18).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.5f, (float)23.0f, (float)1.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)2.0f));
        PartDefinition tail1 = tail.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(13, 11).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        tail1.addOrReplaceChild("tail_2", CubeListBuilder.create(), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Squirrel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if ((double)limbSwingAmount > 0.2) {
            float wiggle = Math.min(limbSwingAmount, 0.6f);
            this.tail.xRot = (JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? 2.5f : 0.2f) + (Mth.cos((float)(ageInTicks * 0.6662f)) - 1.0471976f) * wiggle;
            this.tailPart1.xRot = Mth.cos((float)(ageInTicks * 0.7774f)) * 1.2f * wiggle;
            this.tailPart2.xRot = Mth.cos((float)(ageInTicks * 0.8886f + 1.5707964f)) * 1.4f * wiggle;
        } else {
            this.tail.xRot = (JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? 2.5f : 0.2f) + Mth.cos((float)(ageInTicks * 0.3335f)) * 0.15f;
            this.tailPart1.xRot = 0.1f + Mth.cos((float)(ageInTicks * 0.4445f)) * 0.2f;
            this.tailPart2.xRot = 0.1f + Mth.cos((float)(ageInTicks * 0.5555f)) * 0.25f;
        }
    }
}

