/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.MoonwormBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.MoonwormModel;

public class MoonwormRenderer
implements BlockEntityRenderer<MoonwormBlockEntity> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("moonworm.png");
    private final MoonwormModel moonwormModel;

    public MoonwormRenderer(BlockEntityRendererProvider.Context context) {
        this.moonwormModel = new MoonwormModel(context.bakeLayer(TFModelLayers.MOONWORM));
    }

    public void render(@Nullable MoonwormBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        int yaw;
        int n = yaw = entity != null ? entity.currentYaw : BugModelAnimationHelper.currentRotation;
        if (entity == null) {
            partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        }
        float randRot = entity != null ? entity.randRot : 0.0f;
        stack.pushPose();
        Direction facing = entity != null ? (Direction)entity.getBlockState().getValue((Property)DirectionalBlock.FACING) : Direction.NORTH;
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(facing.getRotation());
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        stack.mulPose(Axis.YP.rotationDegrees(180.0f + randRot));
        stack.mulPose(Axis.YN.rotationDegrees((float)yaw));
        VertexConsumer consumer = buffer.getBuffer(this.moonwormModel.renderType(TEXTURE));
        this.moonwormModel.setRotationAngles(entity, partialTicks);
        this.moonwormModel.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }
}

