/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import twilightforest.client.MagicPaintingTextureManager;
import twilightforest.entity.MagicPainting;
import twilightforest.entity.MagicPaintingVariant;

public class MagicPaintingRenderer
extends EntityRenderer<MagicPainting> {
    public static long lastLightning = 0L;
    protected static final float DAY_LENGTH = 24000.0f;

    public MagicPaintingRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(MagicPainting painting, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        MagicPaintingVariant paintingVariant = (MagicPaintingVariant)painting.getVariant().value();
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        stack.scale(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(painting)));
        this.renderPainting(stack, vertexconsumer, painting, paintingVariant, partialTicks);
        stack.popPose();
        super.render((Entity)painting, yaw, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(MagicPainting painting) {
        return MagicPaintingTextureManager.ATLAS_LOCATION;
    }

    private void renderPainting(PoseStack stack, VertexConsumer vertex, MagicPainting painting, MagicPaintingVariant variant, float partialTicks) {
        ResourceLocation textureLocation = MagicPaintingVariant.getVariantResourceLocation(painting.level().registryAccess(), variant);
        int width = variant.width();
        int height = variant.height();
        int widthAsBlock = width / 16;
        int heightAsBlock = height / 16;
        PoseStack.Pose pose = stack.last();
        float x = (float)(-width) / 2.0f;
        float y = (float)(-height) / 2.0f;
        float z = 0.5f;
        double widthFactor = 1.0 / (double)widthAsBlock;
        double heightFactor = 1.0 / (double)heightAsBlock;
        Direction direction = painting.getDirection();
        int posX = painting.getBlockX();
        int posZ = painting.getBlockZ();
        for (MagicPaintingVariant.Layer layer : variant.layers()) {
            float alpha = this.getAlpha(layer.opacityModifier(), painting, partialTicks);
            if (alpha <= 0.0f) continue;
            MagicPaintingVariant.Layer.Parallax parallax = layer.parallax();
            boolean localLighting = layer.localLighting();
            int layerWidth = parallax != null ? parallax.width() : width;
            int layerHeight = parallax != null ? parallax.height() : height;
            double layerWidthAsBlock = (double)layerWidth / 16.0;
            double layerHeightAsBlock = (double)layerHeight / 16.0;
            double layerWidthFactor = 1.0 / layerWidthAsBlock;
            double layerHeightFactor = 1.0 / layerHeightAsBlock;
            double widthDiff = parallax != null ? (widthFactor - layerWidthFactor) * (double)widthAsBlock * 0.5 : 0.0;
            double widthOffset = widthDiff != 0.0 ? this.getWidthOffset(parallax, painting, widthDiff, partialTicks) : 0.0;
            double heightDiff = parallax != null ? (heightFactor - layerHeightFactor) * (double)heightAsBlock * 0.5 : 0.0;
            double heightOffset = heightDiff != 0.0 ? this.getHeightOffset(parallax, painting, heightDiff, partialTicks) : 0.0;
            TextureAtlasSprite layerTexture = MagicPaintingTextureManager.instance.getLayerSprite(textureLocation, layer);
            for (int k = 0; k < widthAsBlock; ++k) {
                for (int l = 0; l < heightAsBlock; ++l) {
                    float xMax = x + (float)((k + 1) * 16);
                    float xMin = x + (float)(k * 16);
                    float yMax = y + (float)((l + 1) * 16);
                    float yMin = y + (float)(l * 16);
                    if (direction == Direction.NORTH) {
                        posX = Mth.floor((double)(painting.getX() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.WEST) {
                        posZ = Mth.floor((double)(painting.getZ() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.SOUTH) {
                        posX = Mth.floor((double)(painting.getX() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.EAST) {
                        posZ = Mth.floor((double)(painting.getZ() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    int light = layer.fullbright() ? 15728850 : LevelRenderer.getLightColor((BlockAndTintGetter)painting.level(), (BlockPos)new BlockPos(posX, Mth.floor((double)(painting.getY() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                    float xEnd = layerTexture.getU((float)(layerWidthFactor * (double)(widthAsBlock - k) + widthOffset));
                    float xStart = layerTexture.getU((float)(layerWidthFactor * (double)(widthAsBlock - (k + 1)) + widthOffset));
                    float yEnd = layerTexture.getV((float)(layerHeightFactor * (double)(heightAsBlock - l) + heightOffset));
                    float yStart = layerTexture.getV((float)(layerHeightFactor * (double)(heightAsBlock - (l + 1)) + heightOffset));
                    this.vertex(pose, vertex, xMax, yMin, -z, xStart, yEnd, 0, 0, -1, light, alpha, localLighting);
                    this.vertex(pose, vertex, xMin, yMin, -z, xEnd, yEnd, 0, 0, -1, light, alpha, localLighting);
                    this.vertex(pose, vertex, xMin, yMax, -z, xEnd, yStart, 0, 0, -1, light, alpha, localLighting);
                    this.vertex(pose, vertex, xMax, yMax, -z, xStart, yStart, 0, 0, -1, light, alpha, localLighting);
                }
            }
        }
        TextureAtlasSprite backSprite = MagicPaintingTextureManager.instance.getBackSprite(variant);
        for (int w = 0; w < widthAsBlock; ++w) {
            boolean rightBorder;
            boolean leftBorder = w == 0;
            boolean bl = rightBorder = w == widthAsBlock - 1;
            float wShift = (float)(leftBorder ? (rightBorder ? 3 : 0) : (rightBorder ? 2 : 1)) * 0.25f;
            float u0 = backSprite.getU(wShift);
            float u1 = backSprite.getU(wShift + 0.25f);
            float u = Mth.lerp((float)0.0625f, (float)u0, (float)u1);
            float uI = Mth.lerp((float)0.0625f, (float)u1, (float)u0);
            float xMax = x + (float)((w + 1) * 16);
            float xMin = x + (float)(w * 16);
            if (direction == Direction.NORTH) {
                posX = Mth.floor((double)(painting.getX() + (double)((xMax + xMin) / 2.0f / 16.0f)));
            }
            if (direction == Direction.WEST) {
                posZ = Mth.floor((double)(painting.getZ() - (double)((xMax + xMin) / 2.0f / 16.0f)));
            }
            if (direction == Direction.SOUTH) {
                posX = Mth.floor((double)(painting.getX() - (double)((xMax + xMin) / 2.0f / 16.0f)));
            }
            if (direction == Direction.EAST) {
                posZ = Mth.floor((double)(painting.getZ() + (double)((xMax + xMin) / 2.0f / 16.0f)));
            }
            for (int h = 0; h < heightAsBlock; ++h) {
                boolean topBorder;
                boolean bottomBorder = h == 0;
                boolean bl2 = topBorder = h == heightAsBlock - 1;
                float hShift = (float)(bottomBorder ? (topBorder ? 3 : 2) : (topBorder ? 0 : 1)) * 0.25f;
                float v0 = backSprite.getV(hShift);
                float v1 = backSprite.getV(hShift + 0.25f);
                float v = Mth.lerp((float)0.0625f, (float)v0, (float)v1);
                float vI = Mth.lerp((float)0.0625f, (float)v1, (float)v0);
                float yMax = y + (float)((h + 1) * 16);
                float yMin = y + (float)(h * 16);
                int light = LevelRenderer.getLightColor((BlockAndTintGetter)painting.level(), (BlockPos)new BlockPos(posX, Mth.floor((double)(painting.getY() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                this.vertex(pose, vertex, xMax, yMax, z, u1, v0, 0, 0, 1, light, false);
                this.vertex(pose, vertex, xMin, yMax, z, u0, v0, 0, 0, 1, light, false);
                this.vertex(pose, vertex, xMin, yMin, z, u0, v1, 0, 0, 1, light, false);
                this.vertex(pose, vertex, xMax, yMin, z, u1, v1, 0, 0, 1, light, false);
                this.vertex(pose, vertex, xMax, yMax, -z, u1, v0, 0, 1, 0, light, false);
                this.vertex(pose, vertex, xMin, yMax, -z, u0, v0, 0, 1, 0, light, false);
                this.vertex(pose, vertex, xMin, yMax, z, u0, v, 0, 1, 0, light, false);
                this.vertex(pose, vertex, xMax, yMax, z, u1, v, 0, 1, 0, light, false);
                this.vertex(pose, vertex, xMax, yMin, z, u1, vI, 0, -1, 0, light, false);
                this.vertex(pose, vertex, xMin, yMin, z, u0, vI, 0, -1, 0, light, false);
                this.vertex(pose, vertex, xMin, yMin, -z, u0, v1, 0, -1, 0, light, false);
                this.vertex(pose, vertex, xMax, yMin, -z, u1, v1, 0, -1, 0, light, false);
                this.vertex(pose, vertex, xMax, yMax, z, uI, v0, -1, 0, 0, light, false);
                this.vertex(pose, vertex, xMax, yMin, z, uI, v1, -1, 0, 0, light, false);
                this.vertex(pose, vertex, xMax, yMin, -z, u1, v1, -1, 0, 0, light, false);
                this.vertex(pose, vertex, xMax, yMax, -z, u1, v0, -1, 0, 0, light, false);
                this.vertex(pose, vertex, xMin, yMax, -z, u0, v0, 1, 0, 0, light, false);
                this.vertex(pose, vertex, xMin, yMin, -z, u0, v1, 1, 0, 0, light, false);
                this.vertex(pose, vertex, xMin, yMin, z, u, v1, 1, 0, 0, light, false);
                this.vertex(pose, vertex, xMin, yMax, z, u, v0, 1, 0, 0, light, false);
            }
        }
    }

    protected void vertex(PoseStack.Pose pose, VertexConsumer vertex, float x, float y, float z, float u, float v, int normX, int normY, int normZ, int light, boolean localLighting) {
        this.vertex(pose, vertex, x, y, z, u, v, normX, normY, normZ, light, 1.0f, localLighting);
    }

    protected void vertex(PoseStack.Pose pose, VertexConsumer vertex, float x, float y, float z, float u, float v, int normX, int normY, int normZ, int light, float a, boolean localLighting) {
        vertex.addVertex(pose, x, y, z).setColor(255, 255, 255, (int)(255.0f * a)).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light);
        if (localLighting) {
            vertex.setNormal((float)normX, (float)normY, (float)normZ);
        } else {
            vertex.setNormal(pose, (float)normX, (float)normY, (float)normZ);
        }
    }

    protected double getWidthOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double widthDiff, float partialTicks) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    Vec3 camPos = Minecraft.getInstance().cameraEntity != null ? Minecraft.getInstance().cameraEntity.getEyePosition(partialTicks) : Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    Vec3 paintPos = painting.position().relative(painting.getDirection().getOpposite(), 1.0);
                    double x = camPos.x - paintPos.x;
                    double z = camPos.z - paintPos.z;
                    double yRot = Mth.wrapDegrees((float)((float)(Mth.atan2((double)z, (double)x) * 57.2957763671875) - 90.0f - painting.getYRot()));
                    return widthDiff + Mth.clamp((double)(yRot * (double)parallax.multiplier() * widthDiff), (double)(-widthDiff), (double)widthDiff);
                }
                case SINE_TIME: {
                    return widthDiff + Math.sin(((float)painting.tickCount + partialTicks) * parallax.multiplier()) * widthDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.tickCount + partialTicks) * parallax.multiplier();
                    double wholeDiff = widthDiff * 2.0;
                    return widthDiff + ((double)parallax.multiplier() > 0.0 ? -widthDiff + trueTick % wholeDiff : widthDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected double getHeightOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double heightDiff, float partialTicks) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    Vec3 camPos = Minecraft.getInstance().cameraEntity != null ? Minecraft.getInstance().cameraEntity.getEyePosition(partialTicks) : Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    Vec3 paintPos = painting.position().relative(painting.getDirection().getOpposite(), 1.0);
                    double x = camPos.x - paintPos.x;
                    double y = camPos.y - paintPos.y;
                    double z = camPos.z - paintPos.z;
                    double pythagoras = Math.sqrt(x * x + z * z);
                    double xRot = Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)y, (double)pythagoras) * 57.2957763671875))));
                    return heightDiff - Mth.clamp((double)(xRot * (double)parallax.multiplier() * heightDiff), (double)(-heightDiff), (double)heightDiff);
                }
                case SINE_TIME: {
                    return heightDiff - Math.cos(((float)painting.tickCount + partialTicks) * parallax.multiplier()) * heightDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.tickCount + partialTicks) * parallax.multiplier();
                    double wholeDiff = heightDiff * 2.0;
                    return heightDiff - ((double)parallax.multiplier() > 0.0 ? -heightDiff + trueTick % wholeDiff : heightDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected float getAlpha(@Nullable MagicPaintingVariant.Layer.OpacityModifier opacityModifier, MagicPainting painting, float partialTicks) {
        if (opacityModifier == null) {
            return 1.0f;
        }
        float a = 1.0f;
        switch (opacityModifier.type()) {
            case DISTANCE: {
                Vec3 camPos = Optional.ofNullable(Minecraft.getInstance().cameraEntity).map(Entity::getEyePosition).orElse(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
                a = MagicPaintingRenderer.fromTo(opacityModifier.from(), opacityModifier.to(), (float)camPos.distanceTo(painting.position()));
                break;
            }
            case WEATHER: {
                a = painting.level().getRainLevel(partialTicks);
                break;
            }
            case STORM: {
                a = (painting.level().getRainLevel(partialTicks) + painting.level().getThunderLevel(partialTicks)) * 0.5f;
                break;
            }
            case LIGHTNING: {
                ClientLevel clientLevel;
                Level level = painting.level();
                if (!(level instanceof ClientLevel) || !((a = 1.0f - ((float)((clientLevel = (ClientLevel)level).getGameTime() - lastLightning) - partialTicks) * opacityModifier.multiplier()) > 0.0f)) break;
                a *= a;
                break;
            }
            case DAY_TIME: {
                Level level = painting.level();
                if (!(level instanceof ClientLevel)) break;
                ClientLevel level2 = (ClientLevel)level;
                float time = (float)level2.dimensionType().fixedTime().orElse(level2.dayTime()) + partialTicks;
                if (opacityModifier.from() < opacityModifier.to()) {
                    a = 1.0f - Math.abs((time - opacityModifier.from()) / (opacityModifier.to() - opacityModifier.from()) - 0.5f) * 2.0f;
                    break;
                }
                if (time < opacityModifier.to()) {
                    time += 24000.0f;
                }
                a = 1.0f - Math.abs((time - opacityModifier.from()) / (opacityModifier.to() + 24000.0f - opacityModifier.from()) - 0.5f) * 2.0f;
                break;
            }
            case SINE_TIME: {
                a = (float)Math.sin(((float)painting.tickCount + partialTicks) * opacityModifier.multiplier()) * 0.5f + 0.5f;
                break;
            }
            case HEALTH: {
                Entity time = Minecraft.getInstance().getCameraEntity();
                if (!(time instanceof LivingEntity)) break;
                LivingEntity living = (LivingEntity)time;
                a = MagicPaintingRenderer.fromTo(opacityModifier.from(), opacityModifier.to(), living.getHealth());
                break;
            }
            case HUNGER: {
                Entity time = Minecraft.getInstance().getCameraEntity();
                if (!(time instanceof Player)) break;
                Player player = (Player)time;
                FoodData food = player.getFoodData();
                a = MagicPaintingRenderer.fromTo(opacityModifier.from(), opacityModifier.to(), food.getFoodLevel());
                break;
            }
            case HOLDING_ITEM: {
                Entity food = Minecraft.getInstance().getCameraEntity();
                if (!(food instanceof LivingEntity)) break;
                LivingEntity living = (LivingEntity)food;
                ItemStack key = opacityModifier.item();
                if (key == null || living.isHolding(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)key))) break;
                a = 0.0f;
                break;
            }
            case MOB_EFFECT_CATEGORY: {
                Entity key = Minecraft.getInstance().getCameraEntity();
                if (!(key instanceof LivingEntity)) break;
                LivingEntity living = (LivingEntity)key;
                boolean flag = false;
                for (MobEffectInstance effect : living.getActiveEffects()) {
                    if (!opacityModifier.effectCategory().isPresent() || ((MobEffect)effect.getEffect().value()).getCategory() != opacityModifier.effectCategory().get()) continue;
                    flag = true;
                    break;
                }
                a = flag ? 1.0f : 0.0f;
            }
        }
        a = Mth.clamp((float)a, (float)0.0f, (float)1.0f);
        if (opacityModifier.type().powerOfMultiplier()) {
            a = (float)Math.pow(a, opacityModifier.multiplier());
        }
        if (opacityModifier.invert()) {
            a = 1.0f - a;
        }
        a = a * (opacityModifier.max() - opacityModifier.min()) + opacityModifier.min();
        return a;
    }

    protected static float fromTo(float from, float to, float value) {
        if (from < to) {
            return (value - from) / (to - from);
        }
        return (from - value) / (from - to);
    }

    protected int getFrameUV(int i, int maxI) {
        if (maxI <= 1) {
            return 4;
        }
        if (i == 0) {
            return 1;
        }
        if (i == maxI - 1) {
            return 3;
        }
        return 2;
    }
}

