/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.NagaModel;
import twilightforest.entity.boss.Naga;

public class NagaRenderer<T extends Naga, M extends NagaModel<T>>
extends MobRenderer<T, M> {
    public static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("nagahead.png");
    public static final ResourceLocation CHARGING_TEXTURE = TwilightForestMod.getModelTexture("nagahead_charging.png");
    public static final ResourceLocation DAZED_TEXTURE = TwilightForestMod.getModelTexture("nagahead_dazed.png");

    public NagaRenderer(EntityRendererProvider.Context context, M model, float shadowSize) {
        super(context, model, shadowSize);
    }

    protected void scale(T entity, PoseStack stack, float partialTicks) {
        super.scale(entity, stack, partialTicks);
        if (!JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            stack.scale(2.01f, 2.01f, 2.01f);
            stack.translate(0.0f, ((Naga)entity).isDazed() ? 1.075f : 0.75f, ((Naga)entity).isDazed() ? 0.175f : 0.0f);
        } else {
            stack.translate(0.0f, ((Naga)entity).isDazed() ? 0.0f : -0.75f, 0.0f);
        }
    }

    protected float getFlipDegrees(T naga) {
        return naga.isDeadOrDying() ? 0.0f : super.getFlipDegrees(naga);
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((Naga)entity).isDazed()) {
            return DAZED_TEXTURE;
        }
        if (((Naga)entity).isCharging() || entity.isDeadOrDying()) {
            return CHARGING_TEXTURE;
        }
        return TEXTURE;
    }
}

