/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import twilightforest.compat.RecipeViewerConstants;
import twilightforest.compat.emi.TFEmiCompat;
import twilightforest.compat.emi.recipes.TFEmiRecipe;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.item.recipe.UncraftingRecipe;

public class EmiUncraftingRecipe<T extends CraftingRecipe>
extends TFEmiRecipe<T> {
    @Nullable
    private List<EmiIngredient> displayedOutputs;

    public EmiUncraftingRecipe(RecipeHolder<T> recipe) {
        super(TFEmiCompat.UNCRAFTING, recipe, 118, 54);
    }

    @Override
    protected void addInputs(List<EmiIngredient> inputs) {
        Recipe recipe = this.getRecipe().value();
        if (recipe instanceof UncraftingRecipe) {
            UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
            inputs.add(EmiIngredient.of((Ingredient)uncraftingRecipe.getInput(), (long)uncraftingRecipe.getCount()));
        } else {
            inputs.add((EmiIngredient)EmiStack.of((ItemStack)((CraftingRecipe)this.getRecipe().value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        }
    }

    @Override
    protected void addOutputs(List<EmiStack> finalOutput) {
        this.displayedOutputs = new ArrayList<EmiIngredient>();
        ArrayList outputs = new ArrayList(((CraftingRecipe)this.getRecipe().value()).getIngredients());
        outputs.replaceAll(ingredient -> Ingredient.of(Arrays.stream(ingredient.getItems()).filter(o -> !o.is(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS)).filter(o -> o.getCraftingRemainingItem().isEmpty())));
        int offset = 0;
        for (int index = 0; index - offset < outputs.size() && index < 9; ++index) {
            int x = index % 3;
            int y = index / 3;
            if (((CraftingRecipe)this.getRecipe().value()).canCraftInDimensions(x, 3) | ((CraftingRecipe)this.getRecipe().value()).canCraftInDimensions(3, y) && !(this.getRecipe().value() instanceof ShapelessRecipe)) {
                ++offset;
                this.displayedOutputs.add((EmiIngredient)EmiStack.EMPTY);
                continue;
            }
            Ingredient ingredient2 = (Ingredient)outputs.get(index - offset);
            this.displayedOutputs.add(EmiIngredient.of((Ingredient)ingredient2));
            for (ItemStack output : ingredient2.getItems()) {
                finalOutput.add(EmiStack.of((ItemStack)output));
            }
        }
        while (this.displayedOutputs.size() < 9) {
            this.displayedOutputs.add((EmiIngredient)EmiStack.EMPTY);
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        int cost;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 35, 18);
        for (int i = 0; i < this.displayedOutputs.size(); ++i) {
            int x = i % 3;
            int y = i / 3;
            widgets.addSlot(this.displayedOutputs.get(i), x * 18 + 63, y * 18);
        }
        Recipe x = this.getRecipe().value();
        if (x instanceof UncraftingRecipe) {
            UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)x;
            ItemStack[] stacks = uncraftingRecipe.getInput().getItems();
            ItemStack[] stackedStacks = new ItemStack[stacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                stackedStacks[i] = new ItemStack((ItemLike)stacks[0].getItem(), uncraftingRecipe.getCount());
            }
            widgets.addSlot((EmiIngredient)new ListEmiIngredient(Stream.of(stackedStacks).map(EmiStack::of).toList(), (long)uncraftingRecipe.getCount()), 5, 19);
        } else {
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)((CraftingRecipe)this.getRecipe().value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), 5, 14).large(true).recipeContext((EmiRecipe)this);
        }
        Recipe recipe = this.getRecipe().value();
        if (recipe instanceof UncraftingRecipe) {
            UncraftingRecipe ur = (UncraftingRecipe)recipe;
            v0 = ur.getCost();
        } else {
            v0 = cost = RecipeViewerConstants.getRecipeCost(this.displayedOutputs.stream().map(ingredient -> ((EmiStack)ingredient.getEmiStacks().getFirst()).getItemStack()).toList());
        }
        if (cost > 0) {
            String costStr = "" + cost;
            widgets.addText((Component)Component.literal((String)costStr), 48 - Minecraft.getInstance().font.width(costStr), 22, RecipeViewerConstants.getXPColor(cost), true);
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

