/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.CandelabraBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.CandelabraBlockEntity;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.init.TFBlocks;

public class CandleDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        if (!level.isClientSide()) {
            BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            this.setSuccess(CandleDispenseBehavior.tryAddCandle(level, blockpos, stack.getItem()) || CandleDispenseBehavior.tryCreateSkullCandle(level, blockpos, stack.getItem()));
            if (this.isSuccess()) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    private static boolean tryAddCandle(ServerLevel level, BlockPos pos, Item candle) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            int candles;
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (candle == AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(sc.getCandleColor())).asItem() && (candles = ((Integer)(state = level.getBlockState(pos)).getValue((Property)BlockStateProperties.CANDLES)).intValue()) < 4) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.CANDLES, (Comparable)Integer.valueOf(candles + 1)));
                level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.getLightEngine().checkBlock(pos);
                level.sendBlockUpdated(pos, (BlockState)state, (BlockState)state, 1);
                return true;
            }
        } else {
            state = level.getBlockEntity(pos);
            if (state instanceof CandelabraBlockEntity) {
                CandelabraBlockEntity candelabra = (CandelabraBlockEntity)state;
                if (!(candle instanceof BlockItem)) {
                    return false;
                }
                BlockItem block = (BlockItem)candle;
                BlockState state = level.getBlockState(pos);
                for (int i = 0; i < 3; ++i) {
                    Block storedCandle = candelabra.getCandle(i);
                    if (storedCandle != Blocks.AIR) continue;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CandelabraBlock.CANDLES.get(i), (Comparable)Boolean.valueOf(true)));
                    candelabra.setCandle(i, block.getBlock());
                    level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.getLightEngine().checkBlock(pos);
                    level.sendBlockUpdated(pos, state, state, 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean tryCreateSkullCandle(ServerLevel level, BlockPos pos, Item candle) {
        BlockState blockstate = level.getBlockState(pos);
        Block block = blockstate.getBlock();
        if (block instanceof AbstractSkullBlock) {
            AbstractSkullBlock skull = (AbstractSkullBlock)block;
            SkullBlock.Types type = (SkullBlock.Types)skull.getType();
            boolean wall = blockstate.getBlock() instanceof WallSkullBlock;
            switch (type) {
                case SKELETON: {
                    if (wall) {
                        CandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    CandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.SKELETON_SKULL_CANDLE.get(), candle);
                    break;
                }
                case WITHER_SKELETON: {
                    if (wall) {
                        CandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    CandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get(), candle);
                    break;
                }
                case PLAYER: {
                    if (wall) {
                        CandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    CandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.PLAYER_SKULL_CANDLE.get(), candle);
                    break;
                }
                case ZOMBIE: {
                    if (wall) {
                        CandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    CandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.get(), candle);
                    break;
                }
                case CREEPER: {
                    if (wall) {
                        CandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    CandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.CREEPER_SKULL_CANDLE.get(), candle);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static void makeFloorSkull(Level level, BlockPos pos, Block newBlock, Item candle) {
        ResolvableProfile profile = null;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.getOwnerProfile();
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)newBlock.defaultBlockState().setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.getBlockState(pos).getValue((Property)SkullBlock.ROTATION))));
        level.setBlockEntity((BlockEntity)new SkullCandleBlockEntity(pos, (BlockState)((BlockState)newBlock.defaultBlockState().setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.getBlockState(pos).getValue((Property)SkullBlock.ROTATION))), AbstractSkullCandleBlock.candleToCandleColor(candle).getValue()));
        blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.setOwner(profile);
        }
    }

    private static void makeWallSkull(Level level, BlockPos pos, Block newBlock, Item candle) {
        ResolvableProfile profile = null;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.getOwnerProfile();
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)newBlock.defaultBlockState().setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)WallSkullBlock.FACING))));
        level.setBlockEntity((BlockEntity)new SkullCandleBlockEntity(pos, (BlockState)((BlockState)newBlock.defaultBlockState().setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)WallSkullBlock.FACING))), AbstractSkullCandleBlock.candleToCandleColor(candle).getValue()));
        blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.setOwner(profile);
        }
    }
}

