/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.ai.goal.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueen;

public class HoverBeamGoal
extends HoverBaseGoal<SnowQueen> {
    private int hoverTimer;
    private int beamTimer;
    private int seekTimer;
    private final int maxHoverTime;
    private final int maxBeamTime;
    private final int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public HoverBeamGoal(SnowQueen snowQueen, int hoverTime, int dropTime) {
        super(snowQueen, 3.0f, 4.0f);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean canUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        return ((SnowQueen)this.attacker).getCurrentPhase() == SnowQueen.Phase.BEAM;
    }

    public boolean canContinueToUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void stop() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        ((SnowQueen)this.attacker).setBreathing(false);
    }

    public void tick() {
        LivingEntity target;
        if (((SnowQueen)this.attacker).distanceToSqr(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            ((SnowQueen)this.attacker).setBreathing(true);
            this.doRayAttack();
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - ((SnowQueen)this.attacker).getX();
        double offsetY = this.hoverPosY - ((SnowQueen)this.attacker).getY();
        double offsetZ = this.hoverPosZ - ((SnowQueen)this.attacker).getZ();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)Mth.sqrt((float)((float)distanceDesired))) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            ((SnowQueen)this.attacker).push(velX, velY += (double)0.045f, velZ);
        }
        if ((target = ((SnowQueen)this.attacker).getTarget()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            ((SnowQueen)this.attacker).lookAt((Entity)target, tracking, tracking);
            ((SnowQueen)this.attacker).getLookControl().setLookAt((Entity)target, tracking, tracking);
        }
    }

    private void doRayAttack() {
        double range = 20.0;
        double offset = 10.0;
        Vec3 srcVec = new Vec3(((SnowQueen)this.attacker).getX(), ((SnowQueen)this.attacker).getY() + 0.25, ((SnowQueen)this.attacker).getZ());
        Vec3 lookVec = ((SnowQueen)this.attacker).getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        List possibleList = ((SnowQueen)this.attacker).level().getEntities((Entity)this.attacker, ((SnowQueen)this.attacker).getBoundingBox().move(lookVec.x() * offset, lookVec.y() * offset, lookVec.z() * offset).inflate(range, range, range));
        double hitDist = 0.0;
        if (((SnowQueen)this.attacker).isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList(Objects.requireNonNull(((SnowQueen)this.attacker).getParts())));
        }
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                ((SnowQueen)this.attacker).doBreathAttack(possibleEntity);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            ((SnowQueen)this.attacker).doBreathAttack(possibleEntity);
            hitDist = possibleDist;
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.beamY = target.getY();
        this.seekTimer = 0;
    }
}

