/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.biome.Biome;
import twilightforest.beanification.Component;
import twilightforest.util.ColorUtil;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

@Component
public class BiomeColorAlgorithms {
    public int enchanted(int originalColor, int x, int z) {
        BlockPos center = LegacyLandmarkPlacements.getNearestCenterXZ(x / 16, z / 16);
        int cx = center.getX();
        int cz = center.getZ();
        int dist = (int)Mth.sqrt((float)((cx - x) * (cx - x) + (cz - z) * (cz - z)));
        int color = dist * 16;
        if ((color %= 512) > 255) {
            color = 511 - color;
        }
        color = 255 - color;
        return (originalColor & 0xFFFF00) + color;
    }

    public int swamp(Type modifierType) {
        int modifiedColor = switch (modifierType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GrassColor.get((double)0.8f, (double)0.9f);
            case 1 -> FoliageColor.get((double)0.8f, (double)0.9f);
        };
        return ((modifiedColor & 0xFEFEFE) + 0x4E0E4E) / 2;
    }

    public int darkForest(Type modifierType) {
        int modifiedColor = switch (modifierType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GrassColor.get((double)0.7f, (double)0.8f);
            case 1 -> FoliageColor.get((double)0.7f, (double)0.8f);
        };
        return ((modifiedColor & 0xFEFEFE) + 1969742) / 2;
    }

    public int darkForestCenterGrass(double x, double z) {
        double noise = Biome.TEMPERATURE_NOISE.getValue(x * 0.0225, z * 0.0225, false);
        return noise < -0.2 ? 6714688 : 0x554114;
    }

    public int darkForestCenterFoliage(double x, double z) {
        double noise = (Biome.TEMPERATURE_NOISE.getValue(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
        return noise < -0.1 ? 16351774 : 15289876;
    }

    public double spookyNoise(double x, double z) {
        return (Biome.TEMPERATURE_NOISE.getValue(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
    }

    public int spookyGrass(double x, double z) {
        double noise = this.spookyNoise(x, z);
        return ColorUtil.blendColors(12858147, 6013987, noise > 0.6 ? noise * 0.1 : noise);
    }

    public int spookyFoliage(double x, double z) {
        double noise = this.spookyNoise(x, z);
        return ColorUtil.blendColors(0xFF0101, 4849409, noise > 0.6 ? noise * 0.2 : noise);
    }

    public static enum Type {
        Grass,
        Foliage;

    }
}

