/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.util.features.FeatureLogic;

public class BlockSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Stalactite STONE_STALACTITE = new Stalactite((Either<List<Pair<Block, Integer>>, Block>)Either.right((Object)Blocks.STONE), 0.25f, 11, 1);

    public BlockSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.random();
        return BlockSpikeFeature.startSpike(context.level(), context.origin(), STONE_STALACTITE, random, false);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, Stalactite config, RandomSource random, boolean hanging) {
        return BlockSpikeFeature.startSpike(level, startPos, config, random, hanging, Integer.MAX_VALUE);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, Stalactite config, RandomSource random, boolean hanging, int forcedMaxHeight) {
        int maxInclusive = config.maxLength();
        int minInclusive = (int)((float)maxInclusive * config.sizeVariation());
        int length = Mth.randomBetweenInclusive((RandomSource)random, (int)minInclusive, (int)maxInclusive);
        return BlockSpikeFeature.startSpike(level, startPos, config.ores(), length, minInclusive, Math.min(maxInclusive, forcedMaxHeight), 4, hanging, random);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, Either<List<Pair<Block, Integer>>, Block> ore, int length, int lengthMinimum, int lengthMaximum, int clearance, boolean hang, RandomSource random) {
        if (lengthMaximum < Math.max(lengthMinimum, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movingPos = startPos.mutable();
        int clearedLength = 0;
        int dY = hang ? -1 : 1;
        int i = 0;
        while (i < length) {
            clearedLength = i++;
            if (FeatureLogic.worldGenReplaceable(level.getBlockState((BlockPos)movingPos))) break;
            movingPos.move(0, dY, 0);
        }
        movingPos.move(0, dY, 0);
        int remainingScanLength = length - clearedLength + clearance;
        int finalLength = clearedLength - clearance;
        for (int i2 = 0; i2 < remainingScanLength; ++i2) {
            finalLength = clearedLength + i2;
            if (!FeatureLogic.worldGenReplaceable(level.getBlockState((BlockPos)movingPos))) break;
            movingPos.move(0, dY, 0);
        }
        if ((finalLength = Math.min(length, finalLength)) < lengthMinimum || finalLength > lengthMaximum) {
            return false;
        }
        return BlockSpikeFeature.makeSpike(level, startPos, ore, finalLength, dY, random, hang);
    }

    private static boolean makeSpike(WorldGenLevel level, BlockPos startPos, Either<List<Pair<Block, Integer>>, Block> ore, int length, int dY, RandomSource random, boolean hang) {
        BlockPos below;
        BlockState belowState;
        int diameter = (int)((float)length / 4.5f);
        if (!(hang || (belowState = level.getBlockState(below = startPos.below(2))).is(BlockTagGenerator.SUPPORTS_STALAGMITES) || FeatureLogic.worldGenReplaceable(belowState) && belowState.isFaceSturdy((BlockGetter)level, below, Direction.UP) && !FeatureLogic.isBlockNotOk(belowState))) {
            return false;
        }
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int absz;
                int absx = Math.abs(dx);
                int dist = (int)((float)Math.max(absx, absz = Math.abs(dz)) + (float)Math.min(absx, absz) * 0.5f);
                int spikeLength = dist <= 0 ? length : random.nextInt((int)((float)length / ((float)dist + 0.25f)));
                for (int i = -1; i < spikeLength; ++i) {
                    BlockPos placement = startPos.offset(dx, i * dY, dz);
                    if (!FeatureLogic.worldGenReplaceable(level.getBlockState(placement)) || dY <= 0 && placement.getY() >= level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, placement.getX(), placement.getZ()) - 2) continue;
                    if (ore.right().isPresent()) {
                        level.setBlock(placement, ((Block)ore.right().get()).defaultBlockState(), 3);
                        continue;
                    }
                    WeightedRandomList entries = WeightedRandomList.create(((List)ore.left().get()).stream().map(pair -> WeightedEntry.wrap((Object)((Block)pair.getFirst()), (int)((Integer)pair.getSecond()))).toList());
                    level.setBlock(placement, ((Block)entries.getRandom(random).orElse(WeightedEntry.wrap((Object)Blocks.STONE, (int)1)).data()).defaultBlockState(), 3);
                }
            }
        }
        return true;
    }

    public static Stalactite defaultRandom(RandomSource rand) {
        return STONE_STALACTITE;
    }
}

