/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import twilightforest.util.features.FeaturePlacers;

public class DarkCanopyTreeFeature
extends Feature<TreeConfiguration> {
    public DarkCanopyTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> ctx) {
        final WorldGenLevel reader = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        boolean foundDirt = false;
        for (int dy = pos.getY(); dy >= reader.getMinBuildHeight(); --dy) {
            BlockState state = reader.getBlockState(new BlockPos(pos.getX(), dy - 1, pos.getZ()));
            if (state.is(BlockTags.DIRT)) {
                foundDirt = true;
                pos = new BlockPos(pos.getX(), dy, pos.getZ());
                break;
            }
            if (state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(BlockTags.SAND)) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (FeaturePlacers.validTreePos((LevelSimulatedReader)reader, pos.relative(Direction.UP, i))) continue;
            return false;
        }
        for (Direction e : Direction.Plane.HORIZONTAL) {
            if (!reader.getBlockState(pos.relative(e)).is(BlockTags.LOGS)) continue;
            return false;
        }
        TreeConfiguration treeconfiguration = (TreeConfiguration)ctx.config();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.immutable());
            reader.setBlock(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.immutable());
            reader.setBlock(p_160548_, p_160549_, 19);
        };
        FoliagePlacer.FoliageSetter setter = new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos pos, BlockState state) {
                set2.add(pos.immutable());
                reader.setBlock(pos, state, 19);
            }

            public boolean isSet(BlockPos p_272999_) {
                return set2.contains(p_272999_);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
            set3.add(p_225290_.immutable());
            reader.setBlock(p_225290_, p_225291_, 19);
        };
        boolean flag = this.doPlace(reader, rand, pos, biconsumer, biconsumer1, setter, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.decorators.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)reader, biconsumer3, rand, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.decorators.forEach(p_225282_ -> p_225282_.place(treedecorator$context));
            }
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat((Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_160521_ -> {
                DiscreteVoxelShape shape = DarkCanopyTreeFeature.updateLeaves((LevelAccessor)reader, p_160521_, set1, set3);
                StructureTemplate.updateShapeAtEdge((LevelAccessor)reader, (int)3, (DiscreteVoxelShape)shape, (int)p_160521_.minX(), (int)p_160521_.minY(), (int)p_160521_.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private boolean doPlace(WorldGenLevel level, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, BiConsumer<BlockPos, BlockState> consumer1, FoliagePlacer.FoliageSetter foliageSetter, TreeConfiguration config) {
        int i = config.trunkPlacer.getTreeHeight(random);
        int j = config.foliagePlacer.foliageHeight(random, i, config);
        int k = i - j;
        int l = config.foliagePlacer.foliageRadius(random, k);
        BlockPos blockpos = config.rootPlacer.map(placer -> placer.getTrunkOrigin(pos, random)).orElse(pos);
        int i1 = Math.min(pos.getY(), blockpos.getY());
        int j1 = Math.max(pos.getY(), blockpos.getY()) + i + 1;
        if (i1 >= level.getMinBuildHeight() + 1 && j1 <= level.getMaxBuildHeight()) {
            OptionalInt optionalint = config.minimumSize.minClippedHeight();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, blockpos, config);
            if (k1 >= i || optionalint.isPresent() && k1 >= optionalint.getAsInt()) {
                if (config.rootPlacer.isPresent() && !((RootPlacer)config.rootPlacer.get()).placeRoots((LevelSimulatedReader)level, consumer, random, pos, blockpos, config)) {
                    return false;
                }
                List list = config.trunkPlacer.placeTrunk((LevelSimulatedReader)level, consumer1, random, k1, blockpos, config);
                list.forEach(attachment -> config.foliagePlacer.createFoliage((LevelSimulatedReader)level, foliageSetter, random, config, k1, attachment, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader level, int trunkHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = config.minimumSize.getSizeAtHeight(trunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.setWithOffset((Vec3i)pos, k, i, l);
                    if (DarkCanopyTreeFeature.validTreePos(level, (BlockPos)mutable) && config.ignoreVines) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    protected void setBlock(LevelWriter world, BlockPos pos, BlockState state) {
        DarkCanopyTreeFeature.setBlockKnownShape(world, pos, state);
    }

    public static void setBlockKnownShape(LevelWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.setBlock(p_236408_1_, p_236408_2_, 19);
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_67204_.getXSpan(), p_67204_.getYSpan(), p_67204_.getZSpan());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.isInside((Vec3i)blockpos)) continue;
            discretevoxelshape.fill(blockpos.getX() - p_67204_.minX(), blockpos.getY() - p_67204_.minY(), blockpos.getZ() - p_67204_.minZ());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.isInside((Vec3i)blockpos1)) {
                discretevoxelshape.fill(blockpos1.getX() - p_67204_.minX(), blockpos1.getY() - p_67204_.minY(), blockpos1.getZ() - p_67204_.minZ());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.getBlockState((BlockPos)blockpos$mutableblockpos)).hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.immutable());
                DarkCanopyTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.isInside((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.fill(blockpos$mutableblockpos.getX() - p_67204_.minX(), blockpos$mutableblockpos.getY() - p_67204_.minY(), blockpos$mutableblockpos.getZ() - p_67204_.minZ());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_67204_.isInside((Vec3i)blockpos2)) {
                    discretevoxelshape.fill(blockpos2.getX() - p_67204_.minX(), blockpos2.getY() - p_67204_.minY(), blockpos2.getZ() - p_67204_.minZ());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.getBlockState((BlockPos)blockpos$mutableblockpos)).hasProperty((Property)BlockStateProperties.DISTANCE) || (k = ((Integer)blockstate1.getValue((Property)BlockStateProperties.DISTANCE)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(l + 1));
                    DarkCanopyTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.isInside((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.fill(blockpos$mutableblockpos.getX() - p_67204_.minX(), blockpos$mutableblockpos.getY() - p_67204_.minY(), blockpos$mutableblockpos.getZ() - p_67204_.minZ());
                    }
                    set1.add(blockpos$mutableblockpos.immutable());
                }
            }
        }
        return discretevoxelshape;
    }

    public static boolean validTreePos(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES));
    }
}

