/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.util;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.framework.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class ConfigHelper {
    public static void createBackup(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path configPath = fileConfig.getNioPath();
            try {
                if (Files.exists(configPath, new LinkOption[0]) && fileConfig.getFile().length() > 0L) {
                    Path backupPath = configPath.getParent().resolve(fileConfig.getFile().getName() + ".bak");
                    Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                Constants.LOG.debug("Failed to backup config: " + String.valueOf(configPath));
                throw new RuntimeException(e);
            }
        }
    }

    public static void loadConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                fileConfig.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fc = (FileConfig)config;
            fc.close();
        }
    }

    public static void saveConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public static void watchConfig(UnmodifiableConfig config, Runnable callback) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path path = fileConfig.getNioPath();
            try {
                FileWatcher.defaultInstance().setWatch(path, callback);
                Constants.LOG.debug("Watching config: " + String.valueOf(path));
            }
            catch (Exception e) {
                Constants.LOG.debug("Failed to watch config: " + String.valueOf(path), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fc = (FileConfig)config;
            return ConfigHelper.readBytes(fc.getNioPath());
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TomlFormat.instance().createWriter().write(config, (OutputStream)stream);
        return stream.toByteArray();
    }
}

